/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.dialog;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.dialog.VWConfirmRefreshDialog;
import filenet.vw.toolkit.runtime.dialog.VWDeleteWorkConfirmDialog;
import filenet.vw.toolkit.runtime.dialog.VWLockWork;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.runtime.table.VWStepNParticipantRenderer;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class VWDeleteWorkDialog
extends VWModalDialog
implements IVWPropertyChangeListener {
    private Frame m_parentFrame = null;
    private VWTrkDataModel m_trackerDataModel = null;
    VWStepNParticipantRenderer m_stepRenderer = new VWStepNParticipantRenderer();
    private VWStepNParticipantRenderer m_participantRenderer = new VWStepNParticipantRenderer();
    private Vector m_activeSteps = null;
    private Object m_selected = null;
    private VWTrkStepOccurrence m_occurrence = null;
    private Vector m_participants = null;
    private Object[] m_selectedParticipants = null;
    private String m_queueName = null;
    private JLabel m_stepLabel = null;
    private JComboBox m_stepCombo = null;
    private DefaultComboBoxModel m_stepModel = null;
    private JLabel m_participantsLabel = null;
    private JList m_participantList = null;
    private DefaultListModel m_participantModel = null;
    private JLabel m_workQueueLabel = null;
    private JLabel m_queueNameUI = null;
    private JButton m_okButton = null;
    private JButton m_applyButton = null;
    private boolean m_bCanceled = true;
    private VWLockWork m_lockWork = null;

    public VWDeleteWorkDialog(Frame parent, VWTrkDataModel trackerDataModel) throws Exception {
        super(parent);
        this.m_parentFrame = parent;
        this.m_trackerDataModel = trackerDataModel;
        if (trackerDataModel == null) {
            throw new Exception(VWResource.s_nullTrackerDataModel.toString(VWResource.s_terminateWorkDialogTitle));
        }
        this.initData();
        this.setupLayout();
        this.updateControls();
        VWPropertyChangeNotifier.addPropertyChangeListener(this);
        Vector selectedSteps = trackerDataModel.getSelectedSteps();
        if (selectedSteps != null && selectedSteps.size() > 0 && this.m_activeSteps != null && this.m_activeSteps.size() > 0) {
            for (int i = 0; i < selectedSteps.size(); ++i) {
                Object obj = selectedSteps.elementAt(i);
                if (obj == null || this.m_stepModel.getIndexOf(obj) < 0) continue;
                Object selected = this.m_stepModel.getSelectedItem();
                if (selected == obj) break;
                this.m_stepModel.setSelectedItem(obj);
                break;
            }
        }
    }

    protected void initData() {
        Object selected = null;
        VWTrkStep step = null;
        this.m_activeSteps = this.m_trackerDataModel.getActiveSteps();
        this.m_stepModel = new DefaultComboBoxModel();
        if (this.m_activeSteps != null && this.m_activeSteps.size() > 0) {
            for (int i = 0; i < this.m_activeSteps.size(); ++i) {
                Vector occurrences;
                step = (VWTrkStep)this.m_activeSteps.elementAt(i);
                if (step == null || (occurrences = step.getActiveOccurrences()) == null || occurrences.size() <= 0) continue;
                if (occurrences.size() == 0) {
                    this.m_stepModel.addElement(step);
                    continue;
                }
                for (int j = 0; j < occurrences.size(); ++j) {
                    Object obj = occurrences.elementAt(j);
                    if (obj == null || !(obj instanceof VWTrkStepOccurrence)) continue;
                    this.m_stepModel.addElement(obj);
                }
            }
        }
        if (this.m_stepModel.getSize() > 0) {
            selected = this.m_stepModel.getElementAt(0);
        }
        this.initStep(selected);
    }

    private void initParticipants() {
        this.m_participants = this.m_occurrence != null ? this.m_occurrence.getActiveParticipants() : null;
        if (this.m_participantModel == null) {
            this.m_participantModel = new DefaultListModel();
        }
        if (this.m_participantList != null) {
            this.m_participantList.removeSelectionInterval(0, this.m_participantModel.getSize() - 1);
        }
        this.m_participantModel.removeAllElements();
        this.m_queueName = null;
        if (this.m_participants != null && this.m_participants.size() > 0) {
            for (int i = 0; i < this.m_participants.size(); ++i) {
                Object obj = this.m_participants.elementAt(i);
                if (!(obj instanceof VWTrkParticipant)) continue;
                VWTrkParticipant participant = (VWTrkParticipant)obj;
                if (this.m_queueName == null) {
                    this.m_queueName = participant.getQueueName();
                }
                if (participant.isLockedByOther()) continue;
                int loc = this.m_participantModel.size();
                VWParticipant vwParticipantName = participant.getParticipant();
                for (int j = 0; j < this.m_participantModel.size(); ++j) {
                    VWTrkParticipant p = (VWTrkParticipant)this.m_participantModel.getElementAt(j);
                    VWParticipant tempParticipant = p.getParticipant();
                    if (VWStringUtils.compareIgnoreCase(vwParticipantName.getParticipantName(), tempParticipant.getParticipantName()) > 0) continue;
                    loc = j;
                    break;
                }
                if (loc >= this.m_participantModel.size()) {
                    this.m_participantModel.addElement(participant);
                    continue;
                }
                this.m_participantModel.insertElementAt(participant, loc);
            }
        }
    }

    protected void setupLayout() {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension(VWResource.s_terminateWorkDialogDim);
        if (dim == null) {
            dim = new Dimension(450, 300);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWResource.s_terminateWorkDialogTitle);
        this.m_stepLabel = new JLabel(VWResource.s_label.toString(VWResource.s_step));
        this.m_stepCombo = new JComboBox(this.m_stepModel);
        this.m_stepCombo.setRenderer(this.m_stepRenderer);
        this.m_workQueueLabel = new JLabel(VWResource.s_label.toString(VWResource.s_queue));
        this.m_queueNameUI = new JLabel("", 2);
        this.m_participantsLabel = new JLabel(VWResource.s_label.toString(VWResource.s_participants));
        this.m_participantList = new JList(this.m_participantModel);
        this.m_participantList.setCellRenderer(this.m_participantRenderer);
        this.m_okButton = new JButton(VWResource.s_ok);
        this.m_applyButton = new JButton(VWResource.s_apply);
        JButton cancelButton = new JButton(VWResource.s_close);
        JButton helpButton = new JButton(VWResource.s_help);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 23;
        c.fill = 1;
        c.insets = new Insets(4, 4, 4, 4);
        mainPanel.add((Component)this.m_stepLabel, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        mainPanel.add((Component)this.m_stepCombo, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        mainPanel.add((Component)this.m_workQueueLabel, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        mainPanel.add((Component)this.m_queueNameUI, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.anchor = 23;
        c.fill = 2;
        c.weightx = 0.0;
        mainPanel.add((Component)this.m_participantsLabel, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        mainPanel.add((Component)new JScrollPane(this.m_participantList), c);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.m_okButton);
        buttonPanel.add(this.m_applyButton);
        buttonPanel.add(cancelButton);
        buttonPanel.add(helpButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 10, 0));
        contentPane.setLayout(new BorderLayout(6, 6));
        contentPane.add((Component)mainPanel, "Center");
        contentPane.add((Component)buttonPanel, "Last");
        this.m_stepCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    VWDeleteWorkDialog.this.performStepSelected();
                }
            }
        });
        this.m_participantList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                VWDeleteWorkDialog.this.performParticipantSelected();
            }
        });
        this.m_okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWDeleteWorkDialog.this.m_bCanceled = false;
                try {
                    VWDeleteWorkDialog.this.performTerminateWork();
                    VWDeleteWorkDialog.this.setVisible(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                VWDeleteWorkDialog.this.removePropertyChangeListener();
            }
        });
        this.m_applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    VWDeleteWorkDialog.this.performTerminateWork();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWDeleteWorkDialog.this.m_bCanceled = true;
                VWDeleteWorkDialog.this.setVisible(false);
                VWDeleteWorkDialog.this.removePropertyChangeListener();
            }
        });
        helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWHelp.displayPage(VWHelp.Help_Process_Tracker + "bpfpt041.htm");
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        Font boldFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null) {
            boldFont = new Font(font.getName(), 1, font.getSize());
        }
        if (boldFont != null) {
            this.m_stepLabel.setFont(boldFont);
            this.m_workQueueLabel.setFont(boldFont);
            this.m_participantsLabel.setFont(boldFont);
        }
    }

    private void updateControls() {
        if (this.m_selected != null) {
            if (this.m_queueName != null) {
                this.m_queueNameUI.setText(this.m_queueName);
            } else {
                this.m_queueNameUI.setText("");
            }
        } else {
            this.m_workQueueLabel.setEnabled(false);
            this.m_queueNameUI.setText("");
            this.m_queueNameUI.setEnabled(false);
            this.m_participantsLabel.setEnabled(false);
            this.m_participantList.setEnabled(false);
        }
        this.setButtonState();
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    private void performStepSelected() {
        Object obj = this.m_stepCombo.getSelectedItem();
        if (obj != this.m_selected) {
            this.initStep(obj);
            this.updateControls();
        }
    }

    private void performParticipantSelected() {
        this.m_selectedParticipants = this.m_participantList.getSelectedValues();
        this.updateControls();
    }

    private void setButtonState() {
        boolean bEnable = false;
        int[] selection = this.m_participantList.getSelectedIndices();
        if (selection != null && selection.length > 0) {
            bEnable = true;
        }
        this.m_applyButton.setEnabled(bEnable);
        this.m_okButton.setEnabled(bEnable);
    }

    private boolean confirmTerminateWork() {
        VWDeleteWorkConfirmDialog dlg = new VWDeleteWorkConfirmDialog(this);
        dlg.setVisible(true);
        return !dlg.isCanceled();
    }

    private void performTerminateWork() {
        if (!this.confirmTerminateWork()) {
            return;
        }
        boolean bAnyFailed = false;
        boolean bAnySucceeded = false;
        VWTrkParticipant participant = null;
        Object[] selectedParticipants = this.m_participantList.getSelectedValues();
        if (selectedParticipants != null) {
            Cursor currentCursor = null;
            currentCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            boolean bLocked = true;
            try {
                this.m_lockWork = new VWLockWork((Dialog)this, this.m_trackerDataModel, selectedParticipants);
                bLocked = this.m_lockWork.isSuccess();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.s_terminateWorkDialogTitle, 1, null);
                this.m_lockWork = null;
            }
            if (bLocked) {
                for (int i = 0; i < selectedParticipants.length; ++i) {
                    participant = (VWTrkParticipant)selectedParticipants[i];
                    try {
                        participant.doTerminate();
                        bAnySucceeded = true;
                        continue;
                    }
                    catch (VWException ex) {
                        bAnyFailed = true;
                    }
                }
            } else {
                if (this.m_lockWork != null) {
                    this.m_lockWork.unlock();
                }
                JOptionPane.showMessageDialog(this, VWResource.s_someCantBeLocked, VWResource.s_terminateWorkDialogTitle, 1, null);
            }
            this.setCursor(currentCursor);
        }
        if (bAnySucceeded) {
            boolean bSave = true;
            if (this.m_trackerDataModel.isAltered()) {
                VWConfirmRefreshDialog confirmRefreshDialog = new VWConfirmRefreshDialog(this.m_parentFrame, false);
                confirmRefreshDialog.setVisible(true);
                bSave = confirmRefreshDialog.isYes();
            }
            this.m_trackerDataModel.refresh(bSave);
        }
        if (bAnyFailed) {
            if (bAnySucceeded) {
                JOptionPane.showMessageDialog(this, VWResource.s_someFailedToTerminate, VWResource.s_terminateWorkDialogTitle, 1, null);
            } else {
                JOptionPane.showMessageDialog(this, VWResource.s_failedToTerminate, VWResource.s_terminateWorkDialogTitle, 1, null);
            }
        }
    }

    private void initStep(Object obj) {
        this.m_selected = obj;
        if (this.m_selected != null) {
            if (this.m_selected instanceof VWTrkStep) {
                Vector occurrences = ((VWTrkStep)this.m_selected).getActiveOccurrences();
                if (occurrences != null && occurrences.size() > 0) {
                    this.m_occurrence = (VWTrkStepOccurrence)occurrences.elementAt(0);
                }
            } else {
                this.m_occurrence = this.m_selected instanceof VWTrkStepOccurrence ? (VWTrkStepOccurrence)this.m_selected : null;
            }
        }
        this.initParticipants();
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        Object obj = event.getSource();
        if (obj instanceof IVWPropertyChangeSource) {
            IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
            int type = event.getID();
            switch (type) {
                case 704: 
                case 705: {
                    Cursor currentCursor = null;
                    currentCursor = this.getCursor();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        this.initData();
                        this.updateControls();
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                    }
                    this.setCursor(currentCursor);
                }
            }
        }
    }

    private void removePropertyChangeListener() {
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
    }

    public boolean isAnyActiveWork() {
        return this.m_activeSteps != null && this.m_activeSteps.size() > 0;
    }
}

